#' Tidy Handling and Navigation of the Student-Life Dataset
#'
#' Details on the Student-Life dataset as well as the
#' dataset itself are available at
#' https://studentlife.cs.dartmouth.edu/.
#'
#'@section Update: Current updates are available through
#' URL: https://github.com/frycast/studentlife
#'
#'@section  BugReports: https://github.com/frycast/studentlife/issues
#'
#'@description Download, navigate and analyse the Student-Life dataset.
#' The Student-Life dataset contains passive and automatic sensing data
#' from the phones of a class of 48 de-identified Dartmouth college students.
#' It was collected over a 10 week term. Additionally, the dataset contains
#' Ecological Momentary Assessment results along with pre- and post-study
#' mental health surveys, such as the PHQ-9. The intended use is to assess
#' mental health, academic performance and behavioral trends.
#' The raw dataset and additional information is
#' available at <https://studentlife.cs.dartmouth.edu/>.
#'
#'@author Daniel Fryer \email{d.fryer@latrobe.edu.au}
#'@docType package
#'@name studentlife
#'@aliases studentlife-package
NULL
