% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maskAT.r
\name{maskAT}
\alias{maskAT}
\title{Mask And Prepare Data To Analyze Analytical Threshold}
\usage{
maskAT(
  data,
  ref = NULL,
  mask.height = TRUE,
  height = 500,
  mask.sample = TRUE,
  per.dye = TRUE,
  range.sample = 20,
  mask.ils = TRUE,
  range.ils = 10,
  ignore.case = TRUE,
  word = FALSE,
  debug = FALSE
)
}
\arguments{
\item{data}{a data frame containing at least 'Dye.Sample.Peak',
'Sample.File.Name', 'Marker', 'Allele', 'Height', and 'Data.Point'.}

\item{ref}{a data frame containing at least
'Sample.Name', 'Marker', 'Allele'.}

\item{mask.height}{logical to indicate if high peaks should be masked.}

\item{height}{integer for global lower peak height threshold for peaks
to be excluded from the analysis. Active if 'mask.peak=TRUE.}

\item{mask.sample}{logical to indicate if sample allelic peaks should be masked.}

\item{per.dye}{logical TRUE if sample peaks should be masked per dye channel.
FALSE if sample peaks should be masked globally across dye channels.}

\item{range.sample}{integer to specify the masking range in (+/-) data points.
Active if mask.sample=TRUE.}

\item{mask.ils}{logical to indicate if internal lane standard peaks should be masked.}

\item{range.ils}{integer to specify the masking range in (+/-) data points.
Active if mask.ils=TRUE.}

\item{ignore.case}{logical to indicate if sample matching should ignore case.}

\item{word}{logical to indicate if word boundaries should be added before sample matching.}

\item{debug}{logical to indicate if debug information should be printed.}
}
\value{
data.frame with added columns 'Dye' and 'ILS'.
}
\description{
Break-out function to prepare data for the function \code{calculateAT}.
}
\details{
Prepares the 'SamplePlotSizingTable' for analysis of analytical threshold. It is needed
by the plot functions for control of masking. The preparation consist of
converting the 'Height' and 'Data.Point' column to numeric (if needed), then
dye channel information is extracted from the 'Dye.Sample.Peak' column and
added to its own 'Dye' column, known fragments of the internal lane standard
(marked with an asterisk '*') is flagged as 'TRUE' in a new column 'ILS'.
}
\seealso{
\code{\link{calculateAT}}
}
