% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_tools.R
\name{string_fill}
\alias{string_fill}
\title{Fills a character string up to a size}
\usage{
string_fill(
  x = "",
  n = NULL,
  symbol = " ",
  right = FALSE,
  center = FALSE,
  na = "NA"
)
}
\arguments{
\item{x}{A character vector.}

\item{n}{Integer scalar, possibly equal to \code{NULL} (default). The size up to which the character
vector will be filled. If \code{NULL} (default), it is set to the largest width in the character vector \code{x}.
To handle how the character is filled, see the arguments \code{symbol}, \code{right} and \code{center}.}

\item{symbol}{Character scalar of length 1, default is a space (" "). It is the symbol with which
the string will be filled.}

\item{right}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, then the filling of the string is
done from the left, leading to right-alignment.}

\item{center}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, then the filling of the string will
be balanced so as to center the strings.}

\item{na}{Character scalar or \code{NA}. Default is "NA" (a character string!). What happens to NAs: by default
they are replaced by the character string "NA".}
}
\value{
This functions returns a character vector of the same lenght as the vector in input.
}
\description{
Fills a character string up to a size and handles multibyte encodings
(differently from sprintf).
}
\details{
If you use character filling of the form \code{sprintf("\% 20s", x)} with \verb{x``containing multibyte characters, you may be suprised that all character strings do not end up at the same lenght (the occurrence of this problem depends on many things: encodings are a mess). }string_fill`
uses only base R functions to compensate this. It is slightly slower but, in general, safer.

It also looks a bit like \code{\link[base:format]{base::format()}}, but slightly different (and a bit faster, but more restrictive).
}
\examples{

x = c("apple", "pineapple") 

# simple fill with blank
cat(paste0(string_fill(x), ":", c(3, 7), "€"), sep = "\n")

# center fill
cat(paste0(string_fill(x, center = TRUE), ":", c(3, 7), "€"), sep = "\n")

# changing the length of the fill and the symbol used for filling
cat(paste0(string_fill(x), ":", 
           string_fill(c(3, 7), 3, "0", right = TRUE), "€"), sep = "\n")

# na behavior: default/NA/other
x = c("hello", NA) 
string_fill(x)
string_fill(x, na = NA)
string_fill(x, na = "(missing)")


}
\seealso{
String operations: \code{\link[=string_is]{string_is()}}, \code{\link[=string_get]{string_get()}}, \code{\link[=string_clean]{string_clean()}}, \code{\link[=string_split2df]{string_split2df()}}.
Chain basic operations with \code{\link[=string_ops]{string_ops()}}. Clean character vectors efficiently
with \code{\link[=string_clean]{string_clean()}}.

Use \code{\link[=string_vec]{string_vec()}} to create simple string vectors.

String interpolation combined with operation chaining: \code{\link[=string_magic]{string_magic()}}. You can change \code{string_magic}
default values with \code{\link[=string_magic_alias]{string_magic_alias()}} and add custom operations with \code{\link[=string_magic_register_fun]{string_magic_register_fun()}}.

Display messages while benefiting from \code{string_magic} interpolation with \code{\link[=cat_magic]{cat_magic()}} and \code{\link[=message_magic]{message_magic()}}.

Other tools with aliases: 
\code{\link{cat_magic_alias}()},
\code{\link{string_magic}()},
\code{\link{string_magic_alias}()},
\code{\link{string_ops_alias}()},
\code{\link{string_vec_alias}()}
}
\author{
Laurent R. Berge
}
