% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_subset}
\alias{stri_subset}
\alias{stri_subset_charclass}
\alias{stri_subset_coll}
\alias{stri_subset_fixed}
\alias{stri_subset_regex}
\title{Select Elements that Match a Given Pattern}
\usage{
stri_subset(str, ..., regex, fixed, coll, charclass)

stri_subset_fixed(str, pattern, omit_na = FALSE, ..., opts_fixed = NULL)

stri_subset_charclass(str, pattern, omit_na = FALSE)

stri_subset_coll(str, pattern, omit_na = FALSE, ..., opts_collator = NULL)

stri_subset_regex(str, pattern, omit_na = FALSE, ..., opts_regex = NULL)
}
\arguments{
\item{str}{character vector with strings to search in}

\item{...}{supplementary arguments passed to the underlying functions,
including additional settings for \code{opts_collator}, \code{opts_regex},
\code{opts_fixed}, and so on}

\item{pattern,regex,fixed,coll,charclass}{character vector defining search patterns;
for more details refer to \link{stringi-search}}

\item{omit_na}{single logical value; should missing values be excluded
from the result?}

\item{opts_collator,opts_fixed,opts_regex}{a named list used to tune up
a search engine's settings; see
\code{\link{stri_opts_collator}}, \code{\link{stri_opts_fixed}},
and \code{\link{stri_opts_regex}}, respectively; \code{NULL}
for default settings;}
}
\value{
All the functions return a character vector.
As usual, the output encoding is always UTF-8.
}
\description{
These functions return a subvector consisting of
strings that match a given pattern. In other words, they
are roughly equivalent (but faster and easier to use) to a call to
\code{str[\link{stri_detect}(str, ...)]}.
}
\details{
Vectorized over \code{str} and \code{pattern}.
Of course, normally you will use that function in case
of \code{length(str) >= length(pattern)}.

\code{stri_subset} is a convenience function.
It calls either \code{stri_subset_regex},
\code{stri_subset_fixed}, \code{stri_subset_coll},
or \code{stri_subset_charclass},
depending on the argument used.
Unless you are a very lazy person, please call the underlying functions
directly for better performance.
}
\examples{
stri_subset_fixed(c("stringi R", "REXAMINE", "123"), c('i', 'R', '0'))
stri_subset_fixed(c("stringi R", "REXAMINE", "123"), 'R')
stri_subset_charclass(c("stRRRingi","REXAMINE","123"),
   c("\\\\p{Ll}", "\\\\p{Lu}", "\\\\p{Zs}"))
}
\seealso{
Other search_subset: \code{\link{stringi-search}}
}

