% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_trans_general}
\alias{stri_trans_general}
\title{General Text Transforms, Including Transliteration}
\usage{
stri_trans_general(str, id)
}
\arguments{
\item{str}{character vector}

\item{id}{a single string with transform identifier,
see \code{\link{stri_trans_list}}}
}
\value{
Returns a character vector.
}
\description{
\pkg{ICU} General transforms provide a general-purpose package
for processing Unicode text. They are a powerful and flexible mechanism
for handling a variety of different tasks, including:
\itemize{
\item    Upper Case, Lower Case, Title Case, Full/Halfwidth conversions,
\item    Normalization,
\item    Hex and Character Name conversions,
\item    Script to Script conversion/transliteration.
}
}
\details{
\pkg{ICU} Transforms were mainly designed to transliterate characters
from one script to another (for example, from Greek to Latin,
or Japanese Katakana to Latin).
However, the services performed here represent a much more
general mechanism capable of handling a much broader range of tasks.
In particular, the Transforms include pre-built transformations
for case conversions, for normalization conversions, for the removal
of given characters, and also for a variety of language and script
transliterations. Transforms can be chained together to perform
a series of operations and each step of the process can use a
UnicodeSet to restrict the characters that are affected.

To get the list of available transforms,
call \code{\link{stri_trans_list}}.

Note that transliterators are often combined in sequence
to achieve a desired transformation.
This is analogous to the composition of mathematical functions.
For example, given a script that converts lowercase ASCII characters
from Latin script to Katakana script, it is convenient to first
(1) separate input base characters and accents, and then (2)
convert uppercase to lowercase.
To achieve this, a compound transform can be specified as follows:
\code{NFKD; Lower; Latin-Katakana;}
}
\examples{
\donttest{
stri_trans_general("gro\\u00df", "latin-ascii")
stri_trans_general("stringi", "latin-greek")
stri_trans_general("stringi", "latin-cyrillic")
stri_trans_general("stringi", "upper") # see stri_trans_toupper
stri_trans_general("\\u0104", "nfd; lower") # compound id; see stri_trans_nfd
stri_trans_general("tato nie wraca ranki wieczory", "pl-pl_FONIPA")
}
}
\references{
\emph{General Transforms} -- ICU User Guide,
\url{http://userguide.icu-project.org/transforms/general}
}
\seealso{
Other transform: \code{\link{stri_trans_isnfc}},
  \code{\link{stri_trans_isnfd}},
  \code{\link{stri_trans_isnfkc}},
  \code{\link{stri_trans_isnfkc_casefold}},
  \code{\link{stri_trans_isnfkd}},
  \code{\link{stri_trans_nfc}},
  \code{\link{stri_trans_nfd}},
  \code{\link{stri_trans_nfkc}},
  \code{\link{stri_trans_nfkc_casefold}},
  \code{\link{stri_trans_nfkd}};
  \code{\link{stri_trans_list}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}}
}

