% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strata.data.R
\name{strata.data}
\alias{strata.data}
\title{Stratification of Univariate Survey Population Using the Data}
\usage{
strata.data(data, h, n)
}
\arguments{
\item{data}{A vector of values of the survey variable y for
which the OSB are determined}

\item{h}{A numeric: denotes the number of strata to be created.}

\item{n}{A numeric: denotes a fixed total sample size.}
}
\value{
\code{strata.distr} returns Optimum Strata Boundaries (OSB),
stratum weights (Wh), stratum variances (Vh), Optimum Sample Sizes
(nh), stratum population sizes (Nh).
}
\description{
This function takes in the univariate population data
(argument \code{data}) and a fixed sample size (n)
to compute the optimum stratum boundaries (OSB) for a
given number of strata (L), optimum sample sizes (nh),
etc directly from the data. The main idea used is from
Khan et al (2008) whereby the problem of stratification
is formulated into a Mathematical Programming Problem (MPP)
using the best-fit frequency distribution and its parameters
estimated from the data. This MPP is then solved for the
OSB using a Dynamic Programming (DP) solution procedure.
}
\examples{
\dontrun{
data(anaemia)
Iron <- anaemia$Iron
strata.data(Iron, h = 2, n=350)
#--------------------------------------------------------
data(SHS) #Household Spending data from stratification package
weight <- SHS$WEIGHT
hist(weight)
length(weight)
strata.data(weight, h = 2, n=500)
#------------------------------------------
data(sugarcane)
Production <- sugarcane$Production
hist(Production)
strata.data(Production, h = 2, n=1000)
#------------------------------------------
}

}
\seealso{
\code{strata.distr}
}
\author{
Karuna Reddy <reddy_k@usp.ac.fj>\cr MGM Khan <khan_mg@usp.ac.fj>
}
