% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Si.mod.R
\name{Si.mod}
\alias{Si.mod}
\title{Siler model.}
\usage{
Si.mod(data, par = c(-0.15, 1.1, 0.15, 0.005, 0.15), rm = 0,
  method = "Nelder-Mead", control = list(fnscale = -1, maxit = 10000))
}
\arguments{
\item{data}{Data frame with age clases and frequency of occurrence (see Details).}

\item{par}{Initial values for the Siler parameters to be optimized over.}

\item{rm}{The number of age classes that want to be removed from optimization (see Details).}

\item{method}{The method to be used: "Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN"
or "Brent" (see \link{optim}).}

\item{control}{A list of control parameters (see \link{optim}).}
}
\description{
Fit a 5-parameters Competing-Risk Siler model for Animal Mortality.
}
\details{
The data used must be a data frame whose first column is a vector of the estimated ages of the animals found dead and the second the frequency of occurrence of those ages.

All age classes are used for adjustment, in case of whish to remove any of the first age classes due to bias in the sample, indicate it with the parameter "rm" and these will be removed starting from the first age class.
}
\examples{

Si.mod(data = cetaceans, rm = 2,
       par = c(0.3159462,  0.1860541, -1.2802880,  1.1733226,  0.0170314))

Si.mod(data = cetaceans, rm = 1,
       par = c(0.3159462,  0.1860541, -1.2802880,  1.1733226,  0.0170314))

Si.mod(data = cetaceans, rm = 0,
       par = c(0.3159462,  0.1860541, -1.2802880,  1.1733226,  0.0170314))

}
\references{
Siler, W. (1979). A Competing-Risk Model for Animal Mortality. Ecology 60, 750–757.

Siler, W. (1983). Parameters of mortality in human populations with widely varying life spans. Stat. Med. 2, 373–380.

Nocedal, J. and Wright, S. J. (1999). Numerical Optimization. Springer.
}
\seealso{
\link{optim}
}
\keyword{Siler}
\keyword{mortality}
