% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{lm2d}
\alias{lm2d}
\title{List of Matrices to Data-Frame}
\usage{
lm2d(
  lm,
  along = 1,
  fill = FALSE,
  rtn.listnames.nm = "list_names",
  rtn.rownames.nm = "row_names",
  stringsAsFactors = FALSE,
  check.names = FALSE,
  check = TRUE
)
}
\arguments{
\item{lm}{list of matrices.}

\item{along}{numeric vector of length 1 specifying which dimension the matrices
from \code{lm} should be binded along: 1 is for rows and 2 is for columns.}

\item{fill}{logical vector of length 1 specifying whether to fill in missing values
for any matrices from \code{lm} that do not have all the columns. At this time,
\code{fill} is only available for rbinding and only used if \code{along} = 1.}

\item{rtn.listnames.nm}{character of length 1 specifying what the name of the
column containing the names/positions of \code{lm} should be in the returned
data.frame. If NULL, then no column is created for the names/positions of \code{lm}
in the returned data.frame.}

\item{rtn.rownames.nm}{character of length 1 specifying what the name of the
column containing the names/positions of the rows within \code{lm}'s matrices
should be in the returned data.frame. If NULL, then no column is created for
the rownames of \code{lm}'s matrices in the returned data.frame.}

\item{stringsAsFactors}{logical vector of length 1 specifying whether character columns
from \code{lm} should be converted to factors. Note, that is a matrix is character,
then \code{stringsAsFactors} would apply to all columns.}

\item{check.names}{logical vector of length 1 specifying whether the colnames
of the returned data.frame should be checked for duplicates and made unique.
Only used if for cbinding with \code{along} = 2.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{lm} is a list of matrices.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
data.frame with the rows (if \code{along} = 1) or columns (if \code{along}
= 2) of \code{lm} binded together.
}
\description{
\code{lm2d} converts a list of matrices to a data.frame. The function is
primarily for rbinding a list of matrices (\code{along} = 1). An option to
cbind the list of matrices is included (\code{along} = 2), but is just a call to
\code{data.frame(lapply(lm, m2d), stringsAsFactors = stringsAsFactors, check.names = check.names)}.
}
\details{
Another way to convert a list of matrices to a data.frame is to convert the list
dimension, row dimension, and column dimension in the list of matrices all to
variable dimensions in the data.frame. If this is desired, call \code{a2d(lm2a(lm))}
instead of \code{lm2d}.
}
\examples{
# list names and rownames
lm <- asplit(HairEyeColor, MARGIN = 3L)
lm2d(lm) # default
lm2d(lm, rtn.listnames.nm = "Sex", rtn.rownames.nm = "Hair")
# no list names
lm2 <- `names<-`(lm, value = NULL)
lm2d(lm2)
lm2d(lm2, rtn.listnames.nm = NULL)
# no rownames too
lm3 <- lapply(lm2, `rownames<-`, value = NULL)
lm2d(lm3)
lm2d(lm3, rtn.rownames.nm = NULL)
lm2d(lm3, rtn.listnames.nm = NULL, rtn.rownames.nm = NULL)
# cbinding as columns
lm2d(lm3, along = 2)
lm2d(lm3, along = 2, check.names = TRUE)
}
