% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{undim}
\alias{undim}
\title{Undimension an Object}
\usage{
undim(x)
}
\arguments{
\item{x}{object with dimensions (usually an array of some kind)}
}
\value{
\code{x} without any dimensions. If \code{x} is an array, then the return
object will be an atomic vector. If \code{x} is a 1D array, then the returned
vector will have names = the 1D dimnames.
}
\description{
\code{undim} removes all dimensions from an object. This is particularly useful
for simplifying 1D arrays where the dimnames from the array are used for the
returned object. Although the function can also be used when dimensions were
temporarily (or erroneously) given to an object.
}
\examples{
a <- array(NA, dim = 1, dimnames = list("A"))
v <- undim(a)
str(a); str(v)
}
