% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{not.names}
\alias{not.names}
\title{Identify Elements That are Not Names}
\usage{
not.names(x, nm)
}
\arguments{
\item{x}{object with a names attribute}

\item{nm}{character vector specifying the elements to test as names of \code{x}.}
}
\value{
character vector containing the elements of \code{nm} that are not names
of \code{x}.
}
\description{
\code{not.names} identifies which elements from \code{nm} are not names of \code{x}.
If all elements are names, then a character vector of length 0 is returned.
}
\examples{
v <- setNames(object = letters, nm = LETTERS)
not.names(x = v, nm = c("A","a"))
data("mtcars")
not.names(x = mtcars, nm = c("MPG","mpg"))
not.names(x = mtcars, names(mtcars)) # returns a character vector of length 0
}
