% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadABS.R
\name{read_table_builder}
\alias{read_table_builder}
\title{Import and format Australian Bureau of Statistics (ABS) TableBuilder files}
\usage{
read_table_builder(dataset, filetype = "csv", sheet = 1, removeTotal = TRUE)
}
\arguments{
\item{dataset}{Either a dataframe containing the original data from
TableBuilder or a character string containing the path of the
unzipped TableBuilder file.}

\item{filetype}{A character string containing the filetype. Valid values
are 'csv', 'legacycsv' and 'xlsx' (default = 'csv'). Required even when
dataset is a dataframe. Use 'legacycsv' for csv files derived from earlier
versions of TableBuilder for which csv outputs were csv versions of the
xlsx files. Current csv output from TableBuilder follow a more standard
csv format.}

\item{sheet}{An integer value containing the index of the sheet in the
xlsx file (default = 1).}

\item{removeTotal}{A boolean value. If TRUE removes the rows and columns
with totals (default = TRUE).}
}
\description{
Import and format Australian Bureau of Statistics (ABS) TableBuilder files
}
\section{Details}{

The Australian Bureau of Statistics (ABS) provides customised tables for
census and other datasets in a format that is difficult to use in R
because it contains rows with additional information.
This function imports the original (unzipped) TableBuilder files in .csv
or .xlsx format before creating an R dataframe with the data.

Note: we recommend using the
\href{https://github.com/mattcowgill/readabs}{readabs}
package for this purpose.
}

\seealso{
Other data: 
\code{\link{cents_sf}},
\code{\link{destinations_sf}},
\code{\link{flow_dests}},
\code{\link{flowlines_sf}},
\code{\link{flow}},
\code{\link{od_data_lines}},
\code{\link{od_data_routes}},
\code{\link{od_data_sample}},
\code{\link{osm_net_example}},
\code{\link{route_network_sf}},
\code{\link{route_network_small}},
\code{\link{routes_fast_sf}},
\code{\link{routes_slow_sf}},
\code{\link{zones_sf}}
}
\concept{data}
