% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od2odf}
\alias{od2odf}
\title{Extract coordinates from OD data}
\usage{
od2odf(flow, zones)
}
\arguments{
\item{flow}{A data frame representing the flow between two points
or zones. The first two columns of this data frame should correspond
to the first column of the data in the zones. Thus in \code{\link[=cents]{cents()}},
the first column is geo_code. This corresponds to the first two columns
of \code{\link[=flow]{flow()}}.}

\item{zones}{A spatial object representing origins (and destinations
if no separate destinations object is provided) of travel.}
}
\description{
Extract coordinates from OD data
}
\section{Details}{

Origin-destination ('OD') flow data is often provided
in the form of 1 line per flow with zone codes of origin and destination
centroids. This can be tricky to plot and link-up with geographical data.
This function makes the task easier.
}

\examples{
data(flow)
data(zones)
od2odf(flow[1:2, ], zones)
}
\seealso{
Other od: \code{\link{dist_google}}, \code{\link{od2line}},
  \code{\link{od_aggregate_from}},
  \code{\link{od_aggregate_to}},
  \code{\link{od_aggregate}}, \code{\link{od_coords2line}},
  \code{\link{od_coords}}, \code{\link{od_dist}},
  \code{\link{od_radiation}}, \code{\link{points2flow}},
  \code{\link{points2odf}}, \code{\link{sp_aggregate}}
}
\concept{od}
