% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{line2route}
\alias{line2route}
\title{Convert straight SpatialLinesDataFrame from flow data into routes}
\usage{
line2route(l, route_fun = "route_cyclestreet", n_print = 10,
  list_output = FALSE, ...)
}
\arguments{
\item{l}{A SpatialLinesDataFrame}

\item{route_fun}{A routing function to be used for converting the straight lines to routes
\code{\link{od2line}}}

\item{n_print}{A number specifying how frequently progress updates
should be shown}

\item{list_output}{If FALSE (default) assumes SpatialLinesDataFrame output. Set to TRUE to save output as a list.}

\item{...}{Arguments passed to the routing function, e.g. \code{\link{route_cyclestreet}}}
}
\description{
Convert straight SpatialLinesDataFrame from flow data into routes
}
\section{Details}{


See \code{\link{route_cyclestreet}} and other route functions for details
}
\examples{
\dontrun{
data(flowlines)
plot(flowlines)
rf <- line2route(l = flowlines, "route_cyclestreet", plan = "fastest")
rq <- line2route(l = flowlines, plan = "quietest", silent = TRUE)
plot(rf, col = "red", add = TRUE
plot(rq, col = "green", add = TRUE
# Plot for a single line to compare 'fastest' and 'quietest' route
n = 21
plot(flowlines[n,])
lines(rf[n,], col = "red")
lines(rq[n,], col = "green")
# Example with list output
l <- flowlines[1:3,]
rf_list <- line2route(l = l, list_output = TRUE)
class(rf_list)       # list output
class(rf_list[[2]])  # but individual elements are spatial
rf_list_of_lists <- line2route(l = l, list_output = TRUE, save_raw = TRUE)
class(rf_list_of_lists)       # list output
class(rf_list_of_lists[[2]])  # but individual elements are spatial
}
}

