% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata_weibull.R
\name{simdata_weibull}
\alias{simdata_weibull}
\title{Simulate survival data for safety monitoring under Weibull distribution}
\usage{
simdata_weibull(n, p, tau, A, s = 1)
}
\arguments{
\item{n}{Maximum sample size for safety monitoring}

\item{p}{The probability of a toxicity occurring in \code{tau} units of time under the null hypothesis}

\item{tau}{Length of observation period}

\item{A}{Length of accrual period}

\item{s}{Shape parameter for the Weibull distribution; default value is 1
(exponential distribution)}
}
\value{
A matrix with two columns: patient enrollment time and event time
}
\description{
Internal function to simulate survival data from Weibull distribution for evaluating safety
monitoring rules. A random sample of size \code{n} is generated from a Weibull
distribution with shape parameter \code{s} to attain a toxicity rate of \code{p} at
survival time \code{tau}. Enrollment times are also simulated over an accrual period
of duration \code{A} under a uniform (0,\code{A}) distribution.
}
