% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prices_gains.R
\name{prices_gains}
\alias{prices_gains}
\title{Convert Prices to Gains}
\usage{
prices_gains(prices)
}
\arguments{
\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}
}
\value{
Numeric vector or matrix.
}
\description{
Calculates gains based on vector or matrix of prices.
}
\examples{
\dontrun{
# Load 2017 prices for Netflix and Amazon, and calculate growth of $10k
prices <- load_prices(c("NFLX", "AMZN"), initial = 1000)

# Calculate gains
gains <- prices_gains(prices)
}


}
