% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{specify_priors}
\alias{specify_priors}
\title{Specify Prior Distributions for SV Models}
\usage{
specify_priors(
  mu = sv_normal(mean = 0, sd = 100),
  phi = sv_beta(shape1 = 5, shape2 = 1.5),
  sigma2 = sv_gamma(shape = 0.5, rate = 0.5),
  nu = sv_infinity(),
  rho = sv_constant(0),
  latent0_variance = "stationary",
  beta = sv_multinormal(mean = 0, sd = 10000, dim = 1)
)
}
\arguments{
\item{mu}{one of sv_normal and sv_constant}

\item{phi}{one of sv_beta, sv_normal, and sv_constant. If sv_beta, then the specified beta distribution is the prior for (phi+1)/2}

\item{sigma2}{one of sv_gamma, sv_inverse_gamma, and sv_constant}

\item{nu}{one of sv_infinity, sv_exponential, and sv_constant. If sv_exponential, then the specified exponential distribution is the prior for nu-2}

\item{rho}{one of sv_beta and sv_constant. If sv_beta, then the specified beta distribution is the prior for (rho+1)/2}

\item{latent0_variance}{either the character string \code{"stationary"} or an sv_constant object.
If \code{"stationary"}, then h0 ~ N(\code{mu}, \code{sigma^2/(1-phi^2)}). If an sv_constant object with value \code{v}, then h0 ~ N(\code{mu}, \code{v}).
Here, N(b, B) stands for mean b and variance B}

\item{beta}{an sv_multinormal object}
}
\description{
This function gives access to a larger set of prior distributions
in case the default choice is unsatisfactory.
}
\seealso{
Other priors: 
\code{\link{sv_constant}()}
}
\concept{priors}
