% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_analysis.R
\name{meta_analysis}
\alias{meta_analysis}
\title{Random-effects meta-analyses}
\usage{
meta_analysis(
  data,
  type = "parametric",
  random = "mixture",
  k = 2L,
  conf.level = 0.95,
  top.text = NULL,
  ...
)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate} (effect
sizes or outcomes)  and \code{std.error} (corresponding standard errors). These
two columns will be used:
\itemize{
\item as \code{yi}  and \code{sei} arguments in \code{metafor::rma} (for \strong{parametric} test)
or \code{metaplus::metaplus} (for \strong{robust} test)
\item as \code{y} and \code{SE} arguments in \code{metaBMA::meta_random} (for \strong{Bayesian}
test).
}}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{random}{
The type of random effects distribution. One of "normal","t-dist","mixture", for standard normal, \eqn{t}-distribution or mixture of normals respectively.
}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}

\item{top.text}{Text to display on top of the Bayes Factor message. This is
mostly relevant in the context of \code{ggstatsplot} functions.}

\item{...}{Additional arguments passed to the respective meta-analysis
function.}
}
\description{
A dataframe containing results from random-effects meta-analysis.

To see details about functions which are internally used to carry out these
analyses, see the following vignette-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\note{
\strong{Important}: The function assumes that you have already downloaded
the needed package (\code{metafor}, \code{metaplus}, or \code{metaBMA}) for meta-analysis.
If they are not available, you will be asked to install them.
}
\examples{
\donttest{
# run examples only if the needed packages are available
if (all(unlist(lapply(
  c("metaplus", "metafor", "metaBMA"), # needed packages
  require,
  character.only = TRUE,
  quietly = TRUE,
  warn.conflicts = FALSE
)))) {
  # note that the `print` calls below are not necessary for you to write
  # they are in the documentation so that the website renders them

  # setup
  set.seed(123)
  library(statsExpressions)
  options(tibble.width = Inf, pillar.bold = TRUE, pillar.neg = TRUE)

  # renaming to what `statsExpressions` expects
  df <- dplyr::rename(mag, estimate = yi, std.error = sei)

  # ----------------------- parametric ---------------------------------------

  print(meta_analysis(data = df))

  # ----------------------- random -----------------------------------------

  print(meta_analysis(
    data = df,
    type = "random",
    random = "normal"
  ))

  # ----------------------- Bayes Factor -----------------------------------

  meta_analysis(
    data = df,
    type = "bayes",

    # additional arguments given to `metaBMA`
    iter = 5000,
    summarize = "integrate",
    control = list(adapt_delta = 0.99, max_treedepth = 15)
  )
}
}
}
