% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_collisions}
\alias{format_collisions}
\title{Format STATS19 'collisions' data}
\usage{
format_collisions(x)
}
\arguments{
\item{x}{Data frame created with \code{read_collisions()}}
}
\description{
Format STATS19 'collisions' data
}
\section{Details}{

This is a helper function to format raw STATS19 data
}

\examples{
\donttest{
if(curl::has_internet()) {
dl_stats19(year = 2022, type = "collision")
x = read_collisions(year = 2022, format = FALSE)
x = readr::read_csv("https://github.com/ropensci/stats19/releases/download/v3.0.0/fatalities.csv")
if(nrow(x) > 0) {
x[1:3, 1:12]
crashes = format_collisions(x)
crashes[1:3, 1:12]
summary(crashes$datetime)
}
}
}
}
