% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\alias{report}
\title{Compare two statelists}
\usage{
compare(
  df1,
  df2,
  state1 = "gwcode",
  time1 = "year",
  state2 = "gwcode",
  time2 = "year"
)

report(x)
}
\arguments{
\item{df1}{data frame}

\item{df2}{data frame}

\item{state1}{(\code{character(1)}) Name of the country ID var in df1, default
"gwcode"}

\item{time1}{(\code{character(1)}) Name of the time ID var in df1, default "year"}

\item{state2}{(\code{character(1)}) Name of the country ID var in df2, default
"gwcode"}

\item{time2}{(\code{character(1)}) Name of the time ID var in df2, default "year"}

\item{x}{a "state_sets" object produced by \code{compare()}}
}
\description{
Check set overlap between two state lists / data frames, e.g.
prior to merging them.
}
\details{
This is a helper for interactively debugging data merges for data
that may have slightly different state lists. For example, these
differences in case sets could be because of country code differences.
}
\examples{
# df2 has all countries in 2018 but some values in x1 are missing
df1 <- state_panel(2018, 2018, partial = "any")
df1$x1 <- round(runif(nrow(df1))*5)
df1$x1[sample.int(nrow(df1), size = 20, replace = FALSE)] <- NA

# df2 is missing some countries and also has missing values in x2
df2 <- state_panel(2018, 2018, partial = "any")
df2 <- df2[sample.int(nrow(df2), size = 150), ]
df2$x2 <- round(runif(nrow(df2))*5)
df2$x2[sample.int(nrow(df2), size = 20, replace = FALSE)] <- NA

comp <- compare(df1, df2)
comp

report(comp)

}
