% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_update_set_update_record.R
\name{update_record}
\alias{update_record}
\alias{update_record.record_update_set}
\title{Update a dimension record with a set of values}
\usage{
update_record(updates = NULL, dimension, old, values = vector())

\method{update_record}{record_update_set}(updates = NULL, dimension, old, values = vector())
}
\arguments{
\item{updates}{A \code{record_update_set} object.}

\item{dimension}{A \code{dimension_table} object, dimension to update.}

\item{old}{A number, primary key of the record to modify.}

\item{values}{A vector of character values.}
}
\value{
A \code{record_update_set} object.
}
\description{
For a dimension, given the primary key of one record, it adds an update to
the set of updates that modifies the combination of values of the rest of
attributes of the selected record so that they become those given.
}
\details{
Primary key is only used to get the combination of values easily. The
update is defined exclusively from the rest of values.
}
\examples{

library(tidyr)

dim_names <- st_mrs_age \%>\%
    get_dimension_names()

where <- st_mrs_age \%>\%
  get_dimension("where")

# head(where, 2)

updates <- record_update_set() \%>\%
  update_record(
    dimension = where,
    old = 1,
    values = c("1", "CT", "Bridgeport")
  )

}
\seealso{


Other data cleaning functions: 
\code{\link{get_conformed_dimension_names}()},
\code{\link{get_conformed_dimension}()},
\code{\link{get_dimension_names}()},
\code{\link{get_dimension}()},
\code{\link{match_records}()},
\code{\link{modify_conformed_dimension_records}()},
\code{\link{modify_dimension_records}()},
\code{\link{record_update_set}()},
\code{\link{update_selection_general}()},
\code{\link{update_selection}()}
}
\concept{data cleaning functions}
