% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_azimuth.R
\name{w_azimuth}
\alias{w_azimuth}
\title{Create matrix with azimuths to center}
\usage{
w_azimuth(k)
}
\arguments{
\item{k}{Neighborhood size around focal cell. Must be an odd number. For example, \code{k=3} implies a 3*3 neighborhood.}
}
\value{
A \code{matrix} where each cell value is the azimuth from that cell towards the matrix center.
}
\description{
Creates a \code{matrix} with directions (i.e., azimuth) to central cell, of specified size \code{k}. The matrix can be used as weight matrix when calculating the convergence index (see Examples).
}
\examples{
m = w_azimuth(3)
m
m = w_azimuth(5)
m

}
