% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMXStanFit.R
\name{PMXStanFit}
\alias{PMXStanFit}
\title{Generation of a \code{PMXStanFit} object}
\usage{
PMXStanFit(model, dat, ...)
}
\arguments{
\item{model}{a \code{\link{PMXStanModel}} object that needs to have a Stan executable (already compiled from 
the model-specific Stan code) ready for sampling.}

\item{dat}{a named list that provides the input data for the Stan model and other information such as individual 
\code{ID}'s and relevant covariates (specified by users).
Usually generated by \code{\link{prepareInputData}} or modified from the output of the same function.}

\item{...}{any other arguments that are passed to the function \code{\link[rstan]{sampling}}, such as \code{chains},
number of chains to run(default is 4); \code{iter}, number of iterations (default is 2000); and 
\code{thin}, the period for saving samples (default is 1); etc.}
}
\value{
A \code{PMXStanFit} object, with the following list of methods:
\item{get.fit}{returns the output derived from fitting a Stan model, including the samples; the same output as 
               defined by \code{\link[rstan]{stanfit-class}}.
              }
\item{print.fit}{prints out statistics of posterior samples, with the following arguments:

    \code{on.screen}: a logical variable that controls whether or not to print results on screen. Default is \code{TRUE}.
 
    \code{save.mode}: a logical variable that controls whether or not to export results to a text file. Default is \code{TRUE}.
 
    \code{...}: any other arguments that are passed to the more generic function \code{\link[rstan]{print.stanfit}} from 
                \emph{rstan}, such as \code{digits_summary}, number of significant digits for printing out the summary; 
                \code{pars}, parameters in which the summaries are interest;
                \code{probs}, quantiles of interest for summary statistics; etc.
                 
    This function has a generic form as well (see \emph{Examples}).
}
\item{get.path}{returns path of the folder that stores all post-processing results, such as printed statistics for 
                samples and goodness-of-fit plots.
               }
\item{get.waic}{returns diagnostic statistics for a fitted Bayesian model: \emph{Watanabe-Akaike information criterion} 
                (\code{WAIC}) and \emph{Leave-on-out cross-validation} (\code{LOO-CV}).
                The argument \code{complete} allows to select whether to input all pointwise and total statistics 
                (\code{TRUE}) or only total statistics (\code{FALSE}, by default). For more details, see \emph{References}.
                This function has a generic form as well (see \emph{Examples}).
               }
\item{plot.trace}{plots traces and posterior distributions corresponding to one or more Markov chains, therefore to 
                  investigate sampling behavior and to assess mixing across chains and convergence. The argument 
                  \code{pars} specifies names of parameters whose traces will be plotted. When it is not specified, 
                  the function by default plots all the \code{theta}'s (model parameters), \code{sigma_eta}'s 
                  (variance of the inter-individual random effects), and \code{sigma} (variance of the intra-individual
                  random effects) in the auto-generated Stan code.
                  This function has a generic form as well (see \emph{Examples}).
                  For a similar implementation, see \code{\link[rstan]{traceplot}}.
                 }
\item{plot.gof.pred.obs}{plots medians of predictions vs. observations for goodness-of-fit assessment, with 
                         the following arguments:

                         \code{by.cov}: a string to specify the covariate name under investigation. If left as
                                        \code{NULL} by default, the plot will be generated based on the overall
                                        population from all individuals in the input data. To make sure that the
                                        specified covariate name be properly recognized, please also specify it
                                        in the argument \code{covar} when calling \code{\link{prepareInputData}}.                   

                         \code{type}: a string to specify the type of the parameter, can be "categorical" (abbreviated
                                      as "cat") or "continuous" (abbreviated as "con"). This argument is ignored
                                      (automatically set to \code{NULL}) if \emph{by.cov} is not provided by user.

                         \code{cutoff}: a number or vector of numbers to specify the cut-off points by which the
                                        subgroups based on a continuous covariate are defined. If a parameter name
                                        is specified in \emph{by.cov} and the type is specified as "continuous" in
                                        \emph{type}, the default cut-off (when not provided by user) is set as the 
                                        median of the corresponding parameter across the population. This argument
                                        is ignored for a categorical covariate, where the subgroups will be 
                                        automatically determined by all available distinct values of the covariate.

                         \code{filename}: a string to specify the path to store the plots. If not provided by user,
                                          the plots will be output to screen automatically.

                         Noted that a good fit usually results in a group of points clustered around the line of 
                         \code{x=y} representing alignment between observations and predictions. This function has 
                         a generic form as well (see \emph{Examples}).
                        }
\item{plot.gof.pred.rsd}{plots residuals, calculated as the difference between medians of predictions and observations, 
                         vs. predictions as one way of goodness-of-fit assessment, with the same arguments as 
                         \code{plot.gof.pred.rsd()} above. A good fit usually results in a 
                         group of points clustered around the horizontal line of \code{y=0}, without obvious trend of 
                         deviation. This function has a generic form as well (see \emph{Examples}).
                        }
\item{plot.gof.idv}{plots time profiles of the prediction medians and 95% predictive intervals on top of the time 
                    profile of observations. This function has a generic form as well (see \emph{Examples}).
                   }
}
\description{
Reads in data, runs a compiled Stan executable, generates posterior samples for model parameters, 
check convergence, and perform model diagnosis.
}
\details{
Intuitively, a \code{PMXStanFit} object can be uniquely realized by a \code{PMXStanModel} object that has
been compiled successfully, an input list of data that has been prepared compatible to the model object, and a
group of arguments passed to \code{Stan} to run \code{\link[rstan]{sampling}}. 

In addition to serving as an interface to generate samples with \code{Stan}, \code{PMXStanFit} also provides an
interface for users to perform a variety of post-processing procedures by inquiring these samples,  making 
predictions, and comparing with observations. Basic functions are available to investigate sampling behavior 
and check convergence, return diagnostic statistics for a fitted Bayesian model, and generate goodness-of-fit
plots commonly used for PK/PD models, both for the overall population and for subgroups by covariates.

Since all samples from all chains are conveniently accessible, users can also easily boost the capability of
a \code{PMXStanFit} object by writing their own diagnostic/goodness-of-fit/visual predictive checks functions.
}
\examples{
\dontrun{
### A population PK model
m1 <- PMXStanModel(path = tempfile("pk_m1"), pk.struct = "1-cmpt", compile=TRUE)
print(m1)

data("examples_data")
dat <- prepareInputData(data.source = d1_nm_poppk, 
                        model = m1,
                        covar = c("AGE","GENDER")
                       )
fit <- PMXStanFit(m1, dat, iter=100, chains=1)
print(fit, on.screen=F)
save(m1, dat, fit, file = file.path(tempfile("pk_m1"),"ModelFit.RData"))

traces(fit)
waic(fit)
gofplot(fit)

obs.vs.pred(fit, by.cov = "AGE", type = "continuous", 
            cutoff = c(50, 60), filename = "obs_pred_by_age.pdf"
           )
obs.vs.pred(fit, by.cov = "GENDER", type = "categorical", 
            filename = "obs_pred_by_gender.pdf"
           )
rsd.vs.pred(fit, by.cov = "AGE", type = "continuous", 
            cutoff = c(50, 60), filename = "rsd_pred_by_age.pdf"
           )
rsd.vs.pred(fit, by.cov = "GENDER", type = "categorical", 
            filename = "rsd_pred_by_gender.pdf"
           )

### A population PKPD model
ode <- "
  C2 = centr/V;
  d/dt(depot) =-ka*depot;
  d/dt(centr) = ka*depot - ke*centr;
  d/dt(eff) = (1+Emax*C2/(C2+EC50))*Kin - Kout*eff;
"
instant.stan.extension(ode)

}
}
\author{
Yuan Xiong and Wenping Wang
}
\references{
The Stan Development Team. \emph{Stan Modeling Language User's Guide and Reference Manual}. \url{https://mc-stan.org}. 

Aki Vehtari and Andrew Gelman. \emph{WAIC and cross-validation in Stan}. 

Sumio Watanabe. \emph{Asymptotic Equivalence of Bayes Cross Validation and Widely Applicable Information Criterion
in Singular Learning Theory}. \url{https://www.jmlr.org/papers/volume11/watanabe10a/watanabe10a.pdf}.
}
\seealso{
\code{\link{PMXStanModel}} for initialization and compilation of a \code{PMXStanModel} object;
\code{\link{prepareInputData}} for transformation of a NONMEM-readable dataset to a list compatiable to auto-generated 
model-specific Stan code;
\code{\link[rstan]{sampling}} for usage of arguments to draw samples from a compiled Stan model.
}

