% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2-plot-functions.R
\name{barplot.sevt}
\alias{barplot.sevt}
\title{Bar plots of stage probabilities}
\usage{
\method{barplot}{sevt}(
  height,
  var,
  ignore = height$name_unobserved,
  beside = TRUE,
  horiz = FALSE,
  legend.text = FALSE,
  col = NULL,
  xlab = ifelse(horiz, "probability", NA),
  ylab = ifelse(!horiz, "probability", NA),
  ...
)
}
\arguments{
\item{height}{an object of class \code{sevt}.}

\item{var}{name of a variable in \code{object}.}

\item{ignore}{vector of stages which will be ignored and left untouched,
by default the name of the unobserved stages stored in
\code{object$name_unobserved}.}

\item{beside}{a logical value. See \code{\link{barplot}}.}

\item{horiz}{a logical value. See \code{\link{barplot}}.}

\item{legend.text}{logical.}

\item{col}{color mapping for the stages, see \code{col}
argument in \code{\link{plot.sevt}}.}

\item{xlab}{a label for the x axis.}

\item{ylab}{a label for the y axis.}

\item{...}{additional arguments passed to \code{\link{barplot}}.}
}
\value{
As \code{\link{barplot}}:
A numeric vector (or matrix, when beside = TRUE),
giving the coordinates of all the bar midpoints drawn, useful
for adding to the graph.
}
\description{
Create a bar plot visualizing probabilities associated to the
different stages of a variable in a staged event tree.
}
\examples{
model <- stages_fbhc(full(PhDArticles, lambda = 1))
barplot(model, "Kids", beside = TRUE)
}
