% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_mig_env.R
\docType{class}
\name{report_mig_env-class}
\alias{report_mig_env}
\alias{report_mig_env-class}
\title{Class "report_mig_env"}
\description{
Enables to compute an annual overview of fish migration and environmental
conditions in the same chart. Environmental conditions may trigger migration events, variation in flow
or temperatures can  be plotted along migration to check graphically for a possible relation. To enable this, 
environmental conditions are loaded from an "environmental monitoring station", which records environmental
parameters and is attached to a migratory station in the database.
This class enables both continuous output (temperature -flow) as well as discrete parameters (qualitative = moon 
phase, type of operation of a gate, opening of a gate...) which will be displayed on the graph. Values are scaled so that 
single plot can display migration numbers and environmental parameters. Environmental parameters when stored at a 
time scale lower that a day are averaged per day, unless they are qualitative parameters, in which case only the first
event of the day is displayed on the annual plot.
}
\section{Slots}{

\describe{
\item{\code{report_mig_mult}}{\link{report_mig_mult-class}}

\item{\code{report_env}}{\link{report_env-class}}
}}
\examples{
require(stacomiR)
stacomi(gr_interface=FALSE,
	login_window=FALSE,
	database_expected=FALSE)
# the following will load the data provided the user has access to the database
# with data in the iav example scheme.
\dontrun{
  r_mig_env<-new("report_mig_env")
  r_mig_env<-choice_c(r_mig_env,
	  dc=c(5,6,12),
	  taxa=c("Anguilla anguilla"),
	  stage=c("AGJ","AGG","CIV"),
	  stationMesure=c("temp_gabion","coef_maree","phases_lune"),
	  datedebut="2008-01-01",
	  datefin="2008-12-31",
	  silent=FALSE)	
  r_mig_env<-charge(r_mig_env) # this is necessary to load operations, DF and DC
  r_mig_env<-connect(r_mig_env)
  r_mig_env<-calcule(r_mig_env,silent=TRUE)
}	

data("r_mig_env")
# An example of plot with custom colors.
plot(r_mig_env,
	color_station=c("temp_gabion"="red","coef_maree"="blue","phases_lune"="pink"),
 	color_dc=c("5"="yellow","6"="orange","12"="purple")
)
}
\author{
cedric.briand"at"eptb-vilaine.fr marion.legrand"at"logrami.fr

Cedric Briand \email{cedric.briand"at"eptb-vilaine.fr}
}
\seealso{
Other report.Objects: \code{\link{report_annual-class}},
  \code{\link{report_dc-class}},
  \code{\link{report_df-class}},
  \code{\link{report_env-class}},
  \code{\link{report_ge_weight-class}},
  \code{\link{report_mig-class}},
  \code{\link{report_mig_char-class}},
  \code{\link{report_mig_interannual-class}},
  \code{\link{report_mig_mult-class}},
  \code{\link{report_sample_char-class}},
  \code{\link{report_sea_age-class}},
  \code{\link{report_silver_eel-class}},
  \code{\link{report_species-class}}

Other report.Objects: \code{\link{report_annual-class}},
  \code{\link{report_dc-class}},
  \code{\link{report_df-class}},
  \code{\link{report_env-class}},
  \code{\link{report_ge_weight-class}},
  \code{\link{report_mig-class}},
  \code{\link{report_mig_char-class}},
  \code{\link{report_mig_interannual-class}},
  \code{\link{report_mig_mult-class}},
  \code{\link{report_sample_char-class}},
  \code{\link{report_sea_age-class}},
  \code{\link{report_silver_eel-class}},
  \code{\link{report_species-class}}
}
\keyword{classes}

