% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{norm2A}
\alias{norm2A}
\title{Compensate for normalisation in C-modes}
\usage{
norm2A(pfmodel)
}
\arguments{
\item{pfmodel}{object of class parafac}
}
\value{
object of class parafac
}
\description{
Factors used for normalisation are saved separately in the PARAFAC models. With this function, the normalisation factors are combined with the A-modes of the model and removed as a separate vector. This means former normalisation is accounted for in the amount of each component in each sample. If no normalisation was done, the original model is returned without warning.
}
\examples{
data(pfres_comps1)

pfres_comps[[2]][[3]] <- norm2A(pfres_comps[[2]][[3]])
}
