% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonLifeRisk-base.R
\name{print.nonLifeRisk}
\alias{print.nonLifeRisk}
\title{Printing a nonLifeRisk}
\usage{
\method{print}{nonLifeRisk}(x, ...)
}
\arguments{
\item{x}{an S3 object of class nonLifeRisk.}

\item{...}{additional arguments.}
}
\value{
None (invisible NULL).
}
\description{
print method for the S3 class nonLifeRisk.
}
\examples{
# Creating a new nonLifeRisk.
nonLife1 <- nonLifeRisk(type     = "simulations",
                        param    = list(simulations = stats::rnorm(100)),
                        currency =  "CHF")
# printing the nonLifeRisk.
print(nonLife1)
# Creating a new nonLifeRisk.
nonLife2 <- nonLifeRisk(type     = "log-normal",
                        param    = list(mu = 1, sigma = 2),
                        currency =  "CHF")
# printing the nonLifeRisk.
print(nonLife2)
# Creating a new nonLifeRisk.
nonLife3 <- nonLifeRisk(type = "cdf",
                        param = list(cdf = data.frame(x = c(0,1,2,3),
                                                      cdf = c(0.3,0.7,0.9, 1))),
                        currency = "CHF")
# printing the nonLifeRisk.
print(nonLife3)

}
\seealso{
\code{\link[base]{print}}, \code{\link{nonLifeRisk}}.
}
