% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonLifeRisk-base.R
\name{nonLifeRisk}
\alias{nonLifeRisk}
\title{Constructing a nonLifeRisk}
\usage{
nonLifeRisk(type, param, currency)
}
\arguments{
\item{type}{a character value of length one indicating the type of
  simulation used. it can be one of the following option:
  \itemize{
    \item \code{"simulations"}: simulations for non-life risk are directly
      provided.
    \item \code{"log-normal"}: simulations for non-life risk are assumed to
      come from log-normal random variables.

    \item \code{"cdf"}: simulations from non-life risk are simulated from
      an input cumulative distribution function.
  }}

\item{param}{a list of length one or two depending on the \code{type} chosen. The structure
  of the list is conditional on the type of nonLifeRisk:

  if \code{type = "simulations"}, then \code{param} should be a named list with one element:
  \itemize{
    \item \code{simulations}: numeric value representing the input simulations. If the
    number of input simulations are bigger or equal to the number of required
    simulations, then inputs are subsampled. In the other, bootstrap is used.
  }
  if \code{type = "log-normal"}, then \code{param} should be a named list with two elements:
  \itemize{
    \item \code{mu}: numeric value of length one giving the drift of the log-normal variable.
    \item \code{sigma}: strictly positive numeric value of length one giving the volatility
      of the log-normal variable.
  }
  if \code{type = "cdf"} then \code{param} should be a named list with one element:
  \itemize{
    \item \code{cdf}: a \code{data.frame} with two columns named \code{x} and \code{cdf}, where
      the column \code{x} contains the numeric values that represents the possible discrete values
      of the CDF and \code{cdf} the cumulative distribution function evaluated at these possible values.
      Please note that we require the user to provide both columns in an increasing order. We
      additionally require the user to provide a value for \code{cdf == 1} in order to know all the
      jumps possibly taken, since the cdf is right-continous. Morever please consider that
      we interpret the CDF as a piece-wise right-continuous step function.
  }}

\item{currency}{a character value. representing the currency in which the simulations
are expressed. Please note that \code{currency} is restricted to be the same as the
\code{marketRisk} used in conjunction.}
}
\value{
an S3 object, instance of the class nonLifeRisk.
}
\description{
\code{nonLifeRisk} is the constructor for the
  S3 class nonLifeRisk. It allows to build for non-life
  insurance risks simulations.
}
\note{
In case of log-normal simulations, a warning is triggered if the parameters
  seem to be not reasonable and could eventually yield non-finite simulations.
}
\examples{
# Creating new nonLifeRisks.
nonLife1 <- nonLifeRisk(type     = "simulations",
                        param    = list(simulations = stats::rnorm(100)),
                        currency =  "CHF")
nonLife2 <- nonLifeRisk(type     = "log-normal",
                        param    = list(mu = 1, sigma = 2),
                        currency =  "CHF")
nonLife3 <- nonLifeRisk(type = "cdf",
                        param = list(cdf = data.frame(x = c(0,1,2,3),
                                                      cdf = c(0.3,0.7,0.9, 1))),
                        currency = "CHF")

}
\seealso{
\code{\link{summary.nonLifeRisk}}, \code{\link{print.nonLifeRisk}},
\code{\link{simulate.nonLifeRisk}}, \code{\link{compute.nonLifeRisk}}.
}
