% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocess_theta.R
\name{postprocess_theta}
\alias{postprocess_theta}
\title{Post-process Parameter Vector for Generalized Heckman Models}
\usage{
postprocess_theta(theta_par, NXS, NXO, NE, NV, XS, XO, outcomeS, outcomeC)
}
\arguments{
\item{theta_par}{A numeric vector containing the estimated parameters.}

\item{NXS}{Integer. Number of covariates in the selection equation.}

\item{NXO}{Integer. Number of covariates in the outcome equation.}

\item{NE}{Integer. Number of covariates (or 1 for intercept-only) in the scale model.}

\item{NV}{Integer. Number of covariates (or 1 for intercept-only) in the correlation model.}

\item{XS}{Design matrix for the selection equation (used for naming).}

\item{XO}{Design matrix for the outcome equation (used for naming).}

\item{outcomeS}{Design matrix or variable for the scale (variance) model.}

\item{outcomeC}{Design matrix or variable for the correlation model.}
}
\value{
A named numeric vector with:
\itemize{
  \item Transformed \code{sigma} and \code{rho} values (if needed),
  \item Meaningful names assigned to all parameters.
}
}
\description{
Internal helper function that assigns meaningful names to a vector of estimated
parameters and applies transformations to \code{sigma} and \code{rho} parameters
to obtain interpretable estimates.
}
\details{
The parameter vector \code{theta_par} is structured as follows:
\itemize{
  \item The first \code{NXS} elements are coefficients for the selection equation.
  \item The next \code{NXO} elements are coefficients for the outcome equation.
  \item The next \code{NE} elements are coefficients (or log-sigma if \code{NE == 1}) for the scale model.
  \item The next \code{NV} elements are coefficients (or atanh(rho) if \code{NV == 1}) for the correlation model.
}
For interpretation, the function applies:
\itemize{
  \item \code{exp()} transformation for \code{sigma} if \code{NE == 1}.
  \item \code{tanh()} transformation for \code{rho} if \code{NV == 1}.
}
}
\keyword{internal}
