% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{pubkey_filter}
\alias{pubkey_filter}
\title{Filter ssh public keys by type}
\usage{
pubkey_filter(keys, type)
}
\arguments{
\item{keys}{Vector of strings representing ssh public keys.}

\item{type}{Character string defining the ssh public key type that will pass
the filter. Relevant values are strings returned by
\code{attributes(openssl::read_pubkey(pubkey))$class[2]}, \emph{e.g.} "rsa"
and "dsa".}
}
\value{
A vector of strings representing (filtered) public keys.
}
\description{
From a vector of ssh public keys, return those that are of a given type.
}
\examples{
## make ssh public key strings
rsa_pubkey <- openssl::write_ssh(openssl::rsa_keygen()$pubkey)
dsa_pubkey <- openssl::write_ssh(openssl::dsa_keygen()$pubkey)

## filter keys by type
pubkey <- pubkey_filter(c(rsa_pubkey, dsa_pubkey), "rsa")
identical(pubkey, rsa_pubkey)
}
