% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-results.r
\name{get_results_all}
\alias{get_results_all}
\title{Extract SS3 simulation output}
\usage{
get_results_all(directory = getwd(), overwrite_files = FALSE,
  user_scenarios = NULL, parallel = FALSE)
}
\arguments{
\item{directory}{The directory which contains scenario folders with
results.}

\item{overwrite_files}{A switch to determine if existing files should be
overwritten, useful for testing purposes or if new replicates are run.}

\item{user_scenarios}{A character vector of scenarios that should be read
in. Default is \code{NULL}, which indicates find all scenario folders in
\code{directory}.}

\item{parallel}{Should the function be run on multiple cores? You will
need to set up parallel processing as shown in \code{\link{run_ss3sim}}.}
}
\value{
Creates two .csv files in the current working directory:
\code{ss3sim_ts.csv} and \code{ss3sim_scalar.csv}.
}
\description{
This high level function extracts results from SS3 model runs. Give it a
directory which contains directories for different "scenario" runs, within
which are replicates and potentially bias adjustment runs. It writes two
data.frames to file: one for single scalar values (e.g. MSY) and a second
that contains output for each year of the same model (timeseries, e.g.
biomass(year)). These can always be joined later.
}
\seealso{
Other get-results: \code{\link{get_results_derived}},
  \code{\link{get_results_scalar}},
  \code{\link{get_results_scenario}},
  \code{\link{get_results_timeseries}}
}
\author{
Cole Monnahan, Merrill Rudd
}
