% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp2shape.R
\name{sp2shape}
\alias{sp2shape}
\title{Create ESRI Shapefile from sp Package Object}
\usage{
sp2shape(sp.obj, shpfilename = "tempfile", prjfilename = NULL)
}
\arguments{
\item{sp.obj}{The sp package object or object created by either the grts or
irs functions.}

\item{shpfilename}{Name (without any extension) of the output shapefile.
The default is "tempfile".}

\item{prjfilename}{Name (without any extension) of the projection file for
the output shapefile.  The default is NULL.}
}
\value{
An ESRI shapefile of type point, polyline, or polygon.
}
\description{
This function creates an ESRI shapefile from an sp package object.  The
function can also accommodate an object created by the grts or irs functions
in spsurvey.  The type of shapefile, i.e., point, polyline, or polygon, is
determined by the class of the input object, which must be either
"SpatialDesign", "SpatialPointsDataFrame", "SpatialLinesDataFrame", or
"SpatialPolygonsDataFrame".
}
\section{Other Functions Required}{

  \describe{
    \item{\code{writeShapeFilePoint}}{C function to create a point
      shapefile}
    \item{\code{writeShapeFilePolygon}}{C function to create a
      polyline or polygon shapefile}
  }
}

\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
