% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_m_surr.R
\name{methods_m_surr}
\alias{methods_m_surr}
\alias{summary.m_surr}
\alias{plot.m_surr}
\alias{print.m_surr}
\title{Method for class m_surr}
\usage{
\method{summary}{m_surr}(object, ...)

\method{plot}{m_surr}(x, ..., type = 1)

\method{print}{m_surr}(x, ...)
}
\arguments{
\item{object}{object of class \emph{m_surr}.
2 plot W matrix with network}

\item{...}{further arguments passed to or from other methods.}

\item{x}{object of class \emph{m_surr}}

\item{type}{numeric. 1 (default) to get the plot with igraph.}
}
\value{
No return value, called for side effects
}
\description{
A function to plots the m-surrounds give an object of the
class \emph{m_surr} obtain with the code \code{m.surround}.\cr
 The \code{plot()} function allows the user view the configuration of the m-surroundings.\cr
 The argument \code{type} select the type o visualization. \cr
 The \code{print()} print the matrix of the m-surrounding. \cr.
 The \code{summary} give information about the characteristics of the m-surroundings. \cr.
}
\examples{

# Example 1: Obtain m-surroundings with degree of overlapping r
N <- 100
cx <- runif(N)
cy <- runif(N)
x <- cbind(cx,cy)
m = 4
r = 2
msurr_points <- m.surround(x = x, m = m, r = r,control = list(dtmaxabs = 0.5))
plot(msurr_points, type = 1)
plot(msurr_points, type = 2)
print(msurr_points)

# Example 2:
data("FastFood.sf")
m = 6
r = 1
msurr_points <-  m.surround(x = FastFood.sf, m = m, r = r, distance = "Euclidean",
                            control = list(dtmaxpc = .01))
plot(msurr_points, type = 1)
plot(msurr_points, type = 2)
print(msurr_points)

}
\references{
\itemize{
    \item Ruiz, M., López, F., and Páez, A. (2021).
    A test for global and local homogeneity of categorical data based on spatial runs.
      \emph{Working paper}.
  }
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Antonio Páez \tab \email{paezha@gmail.com} \cr
  Manuel Ruiz \tab \email{manuel.ruiz@upct.es} \cr
  }
}
