% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/albums.R
\name{get_albums}
\alias{get_albums}
\title{Get Spotify catalog information for multiple albums identified by their Spotify IDs.}
\usage{
get_albums(
  ids,
  market = NULL,
  authorization = get_spotify_access_token(),
  include_meta_info = FALSE
)
}
\arguments{
\item{ids}{Required. A character vector of the
\href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify IDs} for the albums. Maximum: 20 IDs.}

\item{market}{Optional. \cr
An \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2 country code} or the string \code{"from_token"}. Provide this parameter if you want to apply \href{https://developer.spotify.com/documentation/general/guides/track-relinking-guide/}{Track Relinking}}

\item{authorization}{Required. A valid access token from the Spotify Accounts service.
See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result, with meta information such as \code{"total"}, and \code{"limit"}. Defaults to \code{FALSE}.}
}
\value{
Returns a data frame of results containing album data.
See \url{https://developer.spotify.com/documentation/web-api/reference/albums/get-album/} for more information.
}
\description{
Get Spotify catalog information for multiple albums identified by their Spotify IDs.
}
\seealso{
Other album functions: 
\code{\link{get_album}()}
}
\concept{album functions}
