% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_album_tracks.R
\name{get_album_tracks}
\alias{get_album_tracks}
\title{Get tracks from one or more albums on Spotify}
\usage{
get_album_tracks(albums, access_token = get_spotify_access_token())
}
\arguments{
\item{albums}{Dataframe containing a column `album_uri`, corresponding to Spotify Album URIs. Can be output from spotifyr::get_albums()}

\item{access_token}{Spotify Web API token. Defaults to spotifyr::get_spotify_access_token()}
}
\description{
This function returns tracks from a dataframe of albums on Spotify
}
\examples{
\dontrun{
artists <- get_artists('radiohead')
albums <- get_albums(artists$artist_uri[1])
get_album_tracks(albums)
}
}
\keyword{album}
\keyword{tracks}
