% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluateMissingCandidateSolutions}
\alias{evaluateMissingCandidateSolutions}
\title{evaluateMissingCandidateSolutions}
\usage{
evaluateMissingCandidateSolutions(currX, currY = NULL, fun)
}
\arguments{
\item{currX}{A matrix containing all candidate solutions. One candidate per row.}

\item{currY}{A column vector with all known objective function results for the given matrix of
candidate solutions. Default = NULL (In this case all candidate solutions will be evaluated).
Missing values have to be marked as NA.}

\item{fun}{The objective function on which the given candidate solutions shall be evaluated.}
}
\value{
y An updated column vector with evaluation results for all candidate soltuions
given in currX
}
\description{
\code{evaluateMissingCandidateSolutions} evaluates all non-evaluated
candidate solutions in a gived data.frame. This function is used as a convenience function
for codes that are automatically generated by the SPOT-GUI.
}
\examples{
library(SPOT)
spotData <- NULL
#Generating DOE
spotData$x <- designLHD(x = NULL, lower = c(-5, -5), upper = c(5, 5),
                        control = list(size = 10,
                             types = c("numeric", "numeric")))

#Evaluating Candidate Solutions
spotData$y <- evaluateMissingCandidateSolutions(
        currX = spotData$x, currY = spotData$y, fun = funSphere)

#Build model on evaluated data
spotData$modelFit <- buildKriging(as.matrix(spotData$x),as.matrix(spotData$y))

}
