% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glicko_run.R
\name{glicko_run}
\alias{glicko_run}
\title{Glicko rating algorithm}
\usage{
glicko_run(formula, data, r, rd, sigma, weight, kappa = 0.5, idlab,
  init_r = 1500, init_rd = 350, pb = FALSE)
}
\arguments{
\item{formula}{formula specifying model. Glicko algorithm allows only player ranking parameter and should be specified by following manner: 
`rank | id ~ name`. Names in formula are unrestricted, but model structure remains the same:
\itemize{
 \item {rank} player position in event.
 \item {id} event identifier in which pairwise comparison is assessed.
 \item {name} of player.
}}

\item{data}{data.frame which contains columns specified in formula, and optionaly columns defined by `sigma`, `weight` or `date`.}

\item{r}{named vector of initial players ratings estimates. In there is no assumption, initial ratings are set be r=1500. Names of vector should correspond with `name` in formula.}

\item{rd}{named vector of initial rating deviation estimates. In there is no assumption, initial ratings are set be r=300 Names of vector should correspond with `name` in formula.}

\item{sigma}{name of column in `data` containing rating volatility. Rating volitality is a value which multiplies prior `rd`. If `sigma > 0` then prior `rd` increases, making estimate of `r` more uncertain.}

\item{weight}{name of column in `data` containing weights. Weights increasing or decreasing update change. Higher weight increasing impact of corresponding event.}

\item{kappa}{controls `rd` shrinkage not to be greater than `rd*(1-kappa)`. `kappa=1` means that `rd` will not be decreased.}

\item{idlab}{name of column in `data` containing date. Doesn't affect estimation process. If specified, charts displays estimates changes in time instead of by observation `id`.}

\item{init_r}{initial values for `r` if not provided. Default = 1500}

\item{init_rd}{initial values for `r` if not provided. Default = 350}

\item{pb}{logical, if TRUE progress bar will appear in console. Default = FALSE}
}
\value{
A "rating" object is returned: \itemize{
\item \code{final_r} named vector containing players ratings.
\item \code{final_rd} named vector containing players ratings deviations.
\item \code{r} data.frame with evolution of the ratings and ratings deviations estimated at each event.
\item \code{pairs} pairwise combinations of players in analysed events with prior probability and result of a challange.
\item \code{class} of the object.
\item \code{method} type of algorithm used.
\item \code{formula} modelled formula.
}
}
\description{
Glicko rating algorithm
Wrapper arround `glicko` update algorithm. Wrapper allows user to simplify calculation providing only data and initial parameters assumptions
}
\examples{
# Example from Glickman
data <- data.frame( name = c( "A", "B", "C", "D" ), 
                    rank = c( 3, 4, 1, 2 ))
glicko <- glicko_run( rank ~ name, data )
}
