% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbmokgbmidwpred.R
\name{gbmokgbmidwpred}
\alias{gbmokgbmidwpred}
\title{Generate spatial predictions using the average of the hybrid method of
generalized boosted regression modeling and ordinary kriging and the hybrid method of
generalized boosted regression modeling and inverse distance weighting (gbmokgbmidw)}
\usage{
gbmokgbmidwpred(
  longlat,
  trainx,
  trainy,
  longlatpredx,
  predx,
  var.monotone = rep(0, ncol(trainx)),
  family = "gaussian",
  n.trees = 3000,
  learning.rate = 0.001,
  interaction.depth = 2,
  bag.fraction = 0.5,
  train.fraction = 1,
  n.minobsinnode = 10,
  cv.fold = 0,
  weights = rep(1, nrow(trainx)),
  keep.data = FALSE,
  verbose = TRUE,
  idp = 2,
  nmaxidw = 12,
  nmaxok = 12,
  vgm.args = ("Sph"),
  block = 0,
  n.cores = 6,
  ...
)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of point
samples (i.e., trainx and trainy).}

\item{trainx}{a dataframe or matrix contains columns of predictive variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point locations
(i.e., the centres of grids) to be predicted.}

\item{predx}{a dataframe or matrix contains columns of predictive variables for
the grids to be predicted.}

\item{var.monotone}{an optional vector, the same length as the number of
predictors, indicating which variables have a monotone increasing (+1),
decreasing (-1), or arbitrary (0) relationship with the outcome. By default,
a vector of 0 is used.}

\item{family}{either a character string specifying the name of the distribution to
use or a list with a component name specifying the distribution and any
additional parameters needed. See gbm for details. By default, "gaussian" is
used.}

\item{n.trees}{the total number of trees to fit. This is equivalent to the
number of iterations and the number of basis functions in the additive
expansion. By default, 3000 is used.}

\item{learning.rate}{a shrinkage parameter applied to each tree in the
expansion. Also known as step-size reduction.}

\item{interaction.depth}{the maximum depth of variable interactions.
1 implies an additive model, 2 implies a model with up to 2-way
interactions, etc. By default, 2 is used.}

\item{bag.fraction}{the fraction of the training set observations randomly
selected to propose the next tree in the expansion. By default, 0.5 is used.}

\item{train.fraction}{The first train.fraction * nrows(data) observations
are used to fit the gbm and the remainder are used for computing
out-of-sample estimates of the loss function.}

\item{n.minobsinnode}{minimum number of observations in the trees terminal
nodes. Note that this is the actual number of observations not the total
weight. By default, 10 is used.}

\item{cv.fold}{integer; number of cross-validation folds to perform within
gbm.}

\item{weights}{an optional vector of weights to be used in the fitting
process. Must be positive but do not need to be normalized.
If keep.data = FALSE in the initial call to gbm then it is the user's
responsibility to resupply the weights to gbm.more. By default, a vector of
1 is used.}

\item{keep.data}{a logical variable indicating whether to keep the data and
an index of the data stored with the object. Keeping the data and index
makes subsequent calls to gbm.more faster at the cost of storing an extra
copy of the dataset. By default, 'FALSE' is used.}

\item{verbose}{If TRUE, gbm will print out progress and performance
indicators. By default, 'TRUE' is used.}

\item{idp}{numeric; specify the inverse distance weighting power.}

\item{nmaxidw}{for local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12
observations are used for IDW.}

\item{nmaxok}{for local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12
observations are used for OK.}

\item{vgm.args}{arguments for vgm, e.g. variogram model of response
variable and anisotropy parameters. see notes vgm in gstat for details.
By default, "Sph" is used.}

\item{block}{block size. see krige in gstat for details.}

\item{n.cores}{The number of CPU cores to use. See gbm for details. By
default, 6 is used.}

\item{...}{other arguments passed on to gbm.}
}
\value{
A dataframe of longitude, latitude, predictions and variances. The
variances are the same as the variances of gbmokpred.
}
\description{
This function is to make spatial predictions using the average
of the hybrid method of generalized boosted regression modeling and ordinary
kriging and the hybrid method of generalized boosted regression modeling and
inverse distance weighting.
}
\note{
This function is largely based on gbm. When 'A zero or negative range
was fitted to variogram' occurs, to allow OK running, the range was set
to be positive by using min(vgm1$dist). In this case, caution should be
taken in applying this method, although sometimes it can still outperform
IDW and OK.
}
\examples{
\dontrun{
data(petrel)
data(petrel.grid)
gbmokgbmidwpred1 <- gbmokgbmidwpred(petrel[, c(1,2)], petrel[, c(1,2, 6:9)],
petrel[, 3], petrel.grid[, c(1,2)], petrel.grid, family = "gaussian",
n.cores=6, nmaxidw = 12, nmaxok = 12, vgm.args = ("Sph"))
names(gbmokgbmidwpred1)
}

}
\references{
Greg Ridgeway with contributions from others (2015). gbm:
Generalized Boosted Regression Models. R package version 2.1.1.
https://CRAN.R-project.org/package=gbm
}
\author{
Jin Li
}
