% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splineCoxreg2.R
\name{splineCox.reg2}
\alias{splineCox.reg2}
\title{Fitting the five-parameter spline Cox model with a specified shape, selecting the best fit}
\usage{
splineCox.reg2(
  t.event,
  event,
  Z,
  xi1 = min(t.event),
  xi3 = max(t.event),
  model = names(shape.list),
  p0 = rep(0, 1 + ncol(as.matrix(Z))),
  plot = TRUE
)
}
\arguments{
\item{t.event}{a vector for time-to-event}

\item{event}{a vector for event indicator (=1 event; =0 censoring)}

\item{Z}{a matrix for covariates; nrow(Z)=sample size, ncol(Z)=the number of covariates}

\item{xi1}{lower bound for the hazard function; the default is \code{min(t.event)}}

\item{xi3}{upper bound for the hazard function; the default is \code{max(t.event)}}

\item{model}{A list of character strings and/or numeric vectors of length 5 specifying the shapes of the baseline hazard function to evaluate.
Character options include:
"increase", "constant", "decrease", "unimodal1", "unimodal2", "unimodal3", "bathtub1", "bathtub2", "bathtub3".
Numeric vectors must be of length 5 and will be normalized to have an L1 norm of 1.
Default is \code{names(shape.list)}, which includes all predefined models.}

\item{p0}{Initial values to maximize the likelihood (1 + p parameters; baseline hazard scale parameter and p regression coefficients)}

\item{plot}{A logical value indicating whether to plot the estimated baseline hazard function.
If \code{TRUE}, a plot is generated displaying the estimated baseline hazard function along with its 95\% confidence intervals.
The x-axis represents time, and the y-axis represents the estimated hazard.
The solid line indicates the estimated hazard function, while the dashed red lines represent the confidence intervals.
Default is \code{TRUE}.}
}
\value{
A list containing the following components:
\item{model}{A character string indicating the shape of the baseline hazard function used.}
\item{parameter}{A numeric vector of the parameters defining the baseline hazard shape.}
\item{beta}{A named vector with the estimates, standard errors, and 95\% confidence intervals for the regression coefficients}
\item{gamma}{A named vector with the estimate, standard error, and 95\% confidence interval for the baseline hazard parameter}
\item{loglik}{A named vector containing the log-likelihood (\code{LogLikelihood}),
Akaike Information Criterion (\code{AIC}), and Bayesian Information
Criterion (\code{BIC}) for the best-fitting model}
\item{other_models}{A data frame containing the log-likelihood (\code{LogLikelihood}) for all other evaluated models,
with model names as row names.}
\item{plot}{A baseline hazard function plot for the best-fitting model (if \code{plot = TRUE}).}
}
\description{
\code{splineCox.reg2} estimates the parameters of a five-parameter spline Cox model for multiple specified shapes
and selects the best-fitting model based on the maximization of the log-likelihood function.
This function supports predefined model shapes and custom numeric vectors of length 5.
If numeric vectors are provided, they will be normalized to have an L1 norm of 1.
Additionally, if \code{plot = TRUE}, the function generates a plot of the estimated baseline hazard function for the best-fitting model,
along with its 95\% confidence intervals.
The x-axis represents time, and the y-axis represents the estimated hazard.
The solid line indicates the estimated hazard function, while the dashed red lines represent the confidence intervals.
}
\examples{
# Example data
library(joint.Cox)
data(dataOvarian)
t.event = dataOvarian$t.event
event = dataOvarian$event
Z = dataOvarian$CXCL12

M = c("constant", "increase", "decrease")
reg2 <- splineCox.reg2(t.event, event, Z, model = M)
print(reg2)

}
