% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{try_keep_txt}
\alias{try_keep_txt}
\title{Wrap function to try to keep text}
\usage{
try_keep_txt(f)
}
\arguments{
\item{f}{function to be applied}
}
\value{
modified function f (f').
}
\description{
Function operator returning a function f that tries to keep text.
}
\details{
\code{try_keep_txt} takes a function f as argument, typically a mathematical
operation such as mean, median, etc. and returns a modified version of it that
will try return a string of unique values in case function f emits a warning.
Useful when aggregating over spectral metadata that has both numeric values
(which you want to aggregate) and text values, which you want to keep.
}
\examples{
library(spectrolab)
g = try_keep_txt(mean)
g(c(1, 2))
g(c("a", "b"))
}
\author{
Jose Eduardo Meireles
}
