% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestmethod.R
\name{multibestmethod}
\alias{multibestmethod}
\title{Identify best method for outlier removal for multiple species using majority votes.}
\usage{
multibestmethod(
  x,
  threshold = NULL,
  warn = FALSE,
  verbose = FALSE,
  autothreshold = FALSE
)
}
\arguments{
\item{x}{Output from the outlier detection.}

\item{threshold}{value to consider whether the outlier is an absolute outlier or not.}

\item{warn}{If \strong{TRUE}, warning on whether absolute outliers obtained at a low threshold is indicated. Default \strong{FALSE}.}

\item{verbose}{Produce messages on the process or not. Default \strong{FALSE}.}

\item{autothreshold}{Identifies the threshold with mean number of absolute outliers.The search is limited within 0.51 to 1 since thresholds less than
are deemed inappropriate for identifying absolute outliers. The autothreshold is used when \code{threshold} is set to \code{NULL}.}
}
\value{
best method for outlier detection for each species
}
\description{
Identify best method for outlier removal for multiple species using majority votes.
}
\examples{
\donttest{


danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package = "specleanr"))

preddata <- pred_extract(data = efidata, raster = wcd,
                      lat = 'decimalLatitude', lon = 'decimalLongitude',
                     colsp = 'scientificName',
                     list = TRUE,verbose = FALSE,
                     minpts = 6,merge = FALSE)#'basin removed

 #outlier detection

outliersdf <- multidetect(data = preddata, multiple = TRUE,
                      var = 'bio6',
                      output = 'outlier',
                      exclude = c('x','y'),
                      methods = c('zscore', 'adjbox','iqr', 'semiqr','hampel', 'kmeans',
                                  'logboxplot', 'lof','iforest', 'mahal', 'seqfences'))

multbm <- multibestmethod(x = outliersdf, threshold = 0.2)#
}

}
