% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata.R
\name{getdata}
\alias{getdata}
\title{Download species records from online database.}
\usage{
getdata(
  data,
  colsp = NULL,
  extent = NULL,
  db = c("gbif", "vertnet", "inat"),
  gbiflim = 50000,
  vertlim = 1000,
  inatlim = 3000,
  verbose = FALSE,
  warn = FALSE,
  pct = 80,
  sn = FALSE,
  ...
)
}
\arguments{
\item{data}{\code{dataframe}, \code{list}, \code{vector}, \code{string}. data to retrieve records from online
databases (GBIF, VertNET, and iNaturalist).}

\item{colsp}{\code{string}. A variable of species names. Provided if data is a data frame, so not
required for lists and vector.}

\item{extent}{\code{vector} or \code{sf}. Bounding box to limit the download of records within a particular area. Otherwise all
records from the GBIF will be downloaded. These can be provided in two forms,
either a shapefile \code{(sf)} class accepted or provide a list of named
\code{xmin}, \code{ymin}, \code{xmax}, and \code{ymax} in this particular order.}

\item{db}{\code{vector}. The different databases allowed including \code{'gbif', 'vertnet', and 'inat'}.}

\item{gbiflim}{\code{integer}. Limits on the records from the Global Biodiversity Information Platform}

\item{vertlim}{\code{integer}. Limits on the records from VertNET.}

\item{inatlim}{\code{integer}. Limits on the records from iNaturalist database.}

\item{verbose}{\code{logical}. \strong{TRUE} if detailed messages should be indicated and \strong{FALSE}
if download messages are not needed. Default \strong{TRUE}.}

\item{warn}{\code{logical}. To indicate if warning messages should be shown. Default \code{FALSE}.}

\item{pct}{\code{numeric}. The percentage similarity used to assign a relatively similar name from FishBase if the exact match is absent. Default 90%.
The higher the values, the higher percentage similarity are considered to replace a species name that is cheeked from Fishbase.}

\item{sn}{\code{logical}. Whether to consider synonyms. Default FALSE so accepted names will be considered from
FishBase database.}

\item{...}{More function for species data download can be used.
See \code{rgbif::occ_data} for more information, \code{rinat::get_inat_obs}, and
\code{rvertnet::searchbyterm}.}
}
\value{
Lists of species records from online databases
}
\description{
Download species records from online database.
}
\details{
Note always check the validity of the species name with standard database FishBase or World Register of Marine Species.
       If the records are more than 50000 in GBIF, and extent can be provide to limit the download.
}
\examples{

\dontrun{

gbdata <- getdata(data = 'Gymnocephalus baloni', gbiflim = 100, inatlim = 100, vertlim = 100)

#Get for two species
sp_records <- getdata(data=c('Gymnocephalus baloni', 'Hucho hucho'),
                            gbiflim = 100,
                            inatlim = 100,
                            vertlim = 100)
#for only two databases
sp_records_2db <- getdata(data=c('Gymnocephalus baloni', 'Hucho hucho'),
                           db= c('gbif','inat'),
                            gbiflim = 100,
                            inatlim = 100,
                            vertlim = 100)

}


}
