% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.spdur.R
\name{plot_hazard}
\alias{plot_hazard}
\title{Plot hazard function}
\usage{
plot_hazard(x, t = NULL, ci = TRUE, n = 1000, xvals = NULL,
  zvals = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{spdur}}

\item{t}{Time values at which to evaluate hazard function, e.g. \code{c(1:50)}.
Defaults to 1 through 1.2 * maximum duration value in data.}

\item{ci}{Compute simulation-based confidence interval?}

\item{n}{Number of simulations to use for CI, defaults to 1,000.}

\item{xvals}{A vector of values for the duration equation variables, in the 
same order as the duration equation in \code{x}. Defaults to means.}

\item{zvals}{A vector of values for the risk equation varialbes, in teh same
order as the risk equation in \code{x}. Defaults to means.}

\item{\dots}{Additional parameters passed to \code{\link{plot}}.}
}
\description{
\code{plot_hazard} plots the shape of estimated hazard function in respect 
to duration, given a set of values for the duration and risk equations 
covariates. Confidence intervals are provided through simulation.
}
\examples{
# Get model estimates
data(model.coups)

# Plot
plot_hazard(model.coups, ci = FALSE)
plot_hazard(model.coups, ci = TRUE)

}
\seealso{
\code{\link{separationplot.spdur}}
}

