% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinetic_ising.R
\name{kinetic_ising}
\alias{kinetic_ising}
\title{Ising model for spatial data}
\usage{
kinetic_ising(
  x,
  B,
  J,
  updates = 1,
  iter,
  rule = "glauber",
  inertia = 0,
  version = 1,
  progress = FALSE
)
}
\arguments{
\item{x}{SpatRaster or matrix containing two values: -1 and 1}

\item{B}{External pressure (positive or negative): it tries to align cells' values with its sign}

\item{J}{Strength of the local autocorrelation tendency (always positive): it tries to align signs of neighboring cells}

\item{updates}{Specifies how many sets of iterations are performed on the input object.
The output of this function has as many layers as the \code{updates} value.}

\item{iter}{Specifies how many iterations are performed on the input object.
By default it equals to the number of values in the input object.}

\item{rule}{IM temporal evolution rule: either \code{"glauber"} (default) or \code{"metropolis"}}

\item{inertia}{Represents the modification of the algorithm aimed at suppressing the salt-and-pepper noise of the focus category present when simulating evolution of a coarse-textured pattern. With Q > 0, small patches of the focus category are not generated, thus eliminating the salt-and-pepper noise of the focus category}

\item{version}{By default, \code{1}, the \code{x} object is converted into a matrix
(fast, but can be memory consuming); \code{version = 2} has a lower RAM impact, but
is much slower}

\item{progress}{TRUE/FALSE}
}
\value{
Object of the same class as \code{x} with the number of layers specified by \code{updates}
}
\description{
Performs simulations based on the given parameters of the Ising model
}
\examples{
data(r_start, package = "spatialising")
ts1 = kinetic_ising(r_start, B = -0.3, J = 0.7)
ts10 = kinetic_ising(r_start, B = -0.3, J = 0.7, updates = 10)

\donttest{
  r1 = terra::rast(system.file("raster/r_start.tif", package = "spatialising"))
  terra::plot(r1)
  r2 = kinetic_ising(r1, B = -0.3, J = 0.7)
  terra::plot(r2)

  library(terra)
  ri1 = kinetic_ising(r1, B = -0.3, J = 0.7, updates = 9)
  plot(ri1)

  ri2 = kinetic_ising(r1, B = 0.3, J = 0.7, updates = 9)
  plot(ri2)

  ri3 = kinetic_ising(r1, B = -0.3, J = 0.4, updates = 9)
  plot(ri3)
}
}
\references{
Ising, E., 1924. Beitrag zur theorie des ferro-und paramagnetismus. Ph.D. thesis, Grefe & Tiedemann.

Onsager, L., 1944. Crystal statistics. I. A two-dimensional model with an order-disorder transition. Physical Review 65 (3-4), 117.

Brush, S. G., 1967. History of the Lenz-Ising model. Reviews of modern physics 39 (4), 883.

Cipra, B. A., 1987. An introduction to the Ising model. The American Mathematical Monthly 94 (10), 937–959.
}
