% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_performance.R
\name{print_performance}
\alias{print_performance}
\title{print_performance}
\usage{
print_performance(model)
}
\arguments{
\item{model}{Model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}
}
\value{
Prints model performance scores to the console.
}
\description{
Prints the performance slot of a model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}. For models fitted with \code{\link[=rf_repeat]{rf_repeat()}} it shows the median and the median absolute deviation of each performance measure.
}
\examples{
if(interactive()){

 #loading example data
 data(plant_richness_df)
 data(distance.matrix)

 #fitting a random forest model
 rf.model <- rf(
   data = plant_richness_df,
   dependent.variable.name = "richness_species_vascular",
   predictor.variable.names = colnames(plant_richness_df)[5:21],
   distance.matrix = distance_matrix,
   distance.thresholds = 0,
   n.cores = 1,
   verbose = FALSE
 )

 #printing performance scores
 print_performance(rf.model)

}
}
\seealso{
\code{\link[=print_performance]{print_performance()}}, \code{\link[=get_performance]{get_performance()}}
}
