% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idw.smoothing.R
\name{idw.smoothing}
\alias{idw.smoothing}
\title{Inverse Distance Weighted smoothing}
\usage{
idw.smoothing(x, y, d, k)
}
\arguments{
\item{x}{An sf POINT class object}

\item{y}{Numeric data column in x to be smoothed}

\item{d}{Distance constraint}

\item{k}{Maximum number of k-nearest neighbors within d}
}
\value{
A vector, same length as nrow(x), of smoothed y values
}
\description{
Distance weighted smoothing of a variable in a 
         spatial point object
}
\details{
Smoothing is conducted with a weighted-mean where; weights represent inverse 
standardized distance lags Distance-based or neighbour-based smoothing can be 
specified by setting the desired neighbour smoothing method to a specified value 
then the other parameter to the potential maximum. For example; a constraint 
distance, including all neighbors within 1000 (d=1000) would require k to equal 
all of the potential neighbors (n-1 or k=nrow(x)-1).
}
\examples{

library(sf)
if(require(sp, quietly = TRUE)) {
  data(meuse, package = "sp")
  meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                    agr = "constant")
      
 # Calculate distance weighted mean on cadmium variable in meuse data   
   cadmium.idw <- idw.smoothing(meuse, 'cadmium', k=nrow(meuse), d = 1000)                
   meuse$cadmium.wm <- cadmium.idw
 
   opar <- par(no.readonly=TRUE)
     par(mfrow=c(2,1)) 
       plot(density(meuse$cadmium), main='Cadmium')
       plot(density(meuse$cadmium.wm), main='IDW Cadmium')
   par(opar)

plot(meuse[c("cadmium","cadmium.wm")], pch=20)   

} else { 
  cat("Please install sp package to run example", "\n")
}

}
