% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.holes.R
\name{remove.holes}
\alias{remove.holes}
\title{Remove or return polygon holes}
\usage{
remove.holes(x, only.holes = FALSE)
}
\arguments{
\item{x}{sf POLYGON or MULTIPOLYGON object}

\item{only.holes}{Delete holes (FALSE) or returns only holes (FALSE)}
}
\value{
sf POLYGON object
}
\description{
Removes or returns all holes (null geometry) in sf polygon 
class objects
}
\note{
A hole is considered a polygon within a polygon (island) representing null 
geometry. If you want to return only holes, no longer NULL, use keep = TRUE. 
To delete holes use default only.holes = FALSE. Single part features will be 
returned regardless of input.
}
\examples{
library(sf)

p <- sf::st_as_sf(sf::st_sfc(
  sf::st_polygon(list(
  cbind(c(2,4,4,1,2),c(2,3,5,4,2)),
  cbind(c(2.33, 2.05, 3.25, 3.25, 2.33), 
      c(3.00, 3.56, 3.95, 3.46, 3.00)))),
  sf::st_polygon(list(	
    cbind(c(5,4,2,5),c(2,3,2,2)))),
  sf::st_polygon(list(  
    cbind(c(4,4,5,10,4),c(5,3,2,5,5)),
    cbind(c(5,6,6,5,5),c(4,4,3,3,4)) 
))))
  p$ID <- 1:3

rh <- remove.holes(p)
kh <- remove.holes(p, only.holes=TRUE)

opar <- par(no.readonly=TRUE)
   par(mfrow=c(2,2))
     plot(st_geometry(p), main="Original with holes")
     plot(st_geometry(rh), main="holes removed only.holes=FALSE")
	 plot(st_geometry(kh), main="return holes only.holes=TRUE")
par(opar)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
