% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.deviation.R
\name{raster.deviation}
\alias{raster.deviation}
\title{Raster local deviation from the global trend}
\usage{
raster.deviation(x, type = "trend", s = 3, degree = 1, global = FALSE)
}
\arguments{
\item{x}{raster object}

\item{type}{The global statistic to represent the local deviation  options are: "trend", "min", "max", "mean", "median"}

\item{s}{Size of matrix (focal window), not used with type="trend"}

\item{degree}{The polynomial degree if type is trend, options are 1 and 2.}

\item{global}{Use single global value for deviation or cell-level values (FALSE/TRUE). Argument is ignored for type="trend"}
}
\value{
raster class object of the local deviation from the raster or specified global statistic
}
\description{
Calculates the local deviation from the raster, a specified global statistic or a polynomial trend of the raster.
}
\note{
The deviation from the trend is derived as [y-hat - y] where; y-hat is the Nth-order polynomial.  Whereas the deviation from a global statistic is [y - y-hat] where; y-hat is the local (focal) statistic. 
 The global = TRUE argument allows one to evalute the local deviation from the global statistic [stat(x) - y-hat] where; stat(x) is the global value of the specified staistic and y-hat is the specified focal statistic.
}
\examples{
  library(raster)
  data(elev)

# local deviation from first-order trend, global mean and raw value
r.dev.trend <- raster.deviation(elev, type="trend", degree=1) 
r.dev.mean <- raster.deviation(elev, type="mean", s=5)
r.gdev.mean <- raster.deviation(elev, type="mean", s=5, global=TRUE)

par(mfrow=c(2,2))
  plot(elev, main="original")
  plot(r.dev.trend, main="dev from trend")
  plot(r.dev.mean, main="dev of mean from raw values")
  plot(r.gdev.mean, main="local dev from global mean")

}
\references{
Magee, Lonnie (1998). Nonlocal Behavior in Polynomial Regressions. The American Statistician. American Statistical Association. 52(1):20-22
 Fan, J. (1996). Local Polynomial Modelling and Its Applications: From linear regression to nonlinear regression. Monographs on Statistics and Applied Probability. Chapman and Hall/CRC. ISBN 0-412-98321-4
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
