% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/raster.vol.R
\name{raster.vol}
\alias{raster.vol}
\title{Raster Percent Volume}
\usage{
raster.vol(x, p = 0.95, sample = FALSE, spct = 0.05)
}
\arguments{
\item{x}{raster class object}

\item{p}{percent raster-value volume}

\item{sample}{base volume on systematic point sample (TRUE/FALSE)}

\item{spct}{sample percent, if sample (TRUE)}
}
\value{
if sample (FALSE) binary raster object with 1 representing designated percent volume

if sample (TRUE) n sp SpatialPointsDataFrame object with points that represent the percent volume of the sub-sample
}
\description{
Calculates a percent volume on a raster or based on a systematic sample
}
\note{
Since this model needs to operate on all of the raster values, it is not memory safe
}
\examples{
require(raster)
  r <- raster(ncols=100, nrows=100)
    r[] <- runif(ncell(r), 0, 1)
    r <- focal(r, w=focalWeight(r, 6, "Gauss"))
    r[sample(1000, 1:ncell(r))] <- NA

  # full raster percent volume
  p30 <- raster.vol(r, p=0.30)
  p50 <- raster.vol(r, p=0.50)
  p80 <- raster.vol(r, p=0.80)
    par(mfrow=c(2,2))
    plot(r, col=cm.colors(10), main="original raster")
    plot(p30, breaks=c(0,0.1,1), col=c("cyan","red"), legend=FALSE,
	      main="30\% volume")
    plot(p50, breaks=c(0,0.1,1), col=c("cyan","red"), legend=FALSE,
	      main="50\% volume")
    plot(p80, breaks=c(0,0.1,1), col=c("cyan","red"), legend=FALSE,
	      main="80\% volume")

  # point sample percent volume
  #  p30 <- raster.vol(r, p = 0.30, sample = TRUE, spct = 0.20)
  #    plot(r, main="30\% volume point sample")
  #    plot(p30, pch=20, cex=0.70, add=TRUE)
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}

