% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_plotting.R
\name{plotPRCCSFromTimepointFiles}
\alias{plotPRCCSFromTimepointFiles}
\title{Plots Graphs for Partial Rank Correlation Coefficients Over Time}
\usage{
plotPRCCSFromTimepointFiles(FILEPATH, PARAMETERS, MEASURES, CORCOEFFSFILENAME,
  TIMEPOINTS, TIMEPOINTSCALE, DISPLAYPVALS = FALSE)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs of single CSV file can
be found}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{MEASURES}{Array containing the names of the output measures which are
used to analyse the simulation}

\item{CORCOEFFSFILENAME}{Name of the CSV file containining the correlation
coefficients}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing
multiple simulation timepoints. If only analysing one timepoint, this should
be set to NULL. If not, this should be an array of timepoints,
e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing
multiple simulation timepoints. Sets the scale of the timepoints being
analysed, e.g. "Hours"}

\item{DISPLAYPVALS}{Boolean stating whether PRCC p-values should be printed
on the graph}
}
\description{
Produces plots to show how the impact of a parameter changes over time,
measured by the change in PRCC
}
