% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emulation_sensitivity_analysis.R
\name{emulate_lhc_sampled_parameters}
\alias{emulate_lhc_sampled_parameters}
\title{Emulate simulations for a set of latin-hypercube generated parameter values}
\usage{
emulate_lhc_sampled_parameters(filepath, surrogateModel, parameters, measures,
  measure_scale, param_file = NULL, dataset = NULL, ensemble_set = TRUE,
  normalise = FALSE, timepoint = NULL, timepointscale = NULL)
}
\arguments{
\item{filepath}{Path to where the analysis output should be stored}

\item{surrogateModel}{Ensemble or emulator to use to emulate the simulation
responses for those sets}

\item{parameters}{Simulation parameter names}

\item{measures}{Simulation output response names}

\item{measure_scale}{Scale of each of the simulation responses}

\item{param_file}{Name of the CSV file generated by spartan (or of)
parameter values, separated in columns - if reading these in from a file}

\item{dataset}{Name of the R dataset in the environment that contains the
parameter sets (the tutorial one is emulated_lhc_values)}

\item{ensemble_set}{Boolean stating whether this analysis is being run using
an ensemble of machine learning methods (TRUE), or a single emulator (FALSE)}

\item{normalise}{Whether the parameters in the sampling CSV file need to be
normalised before input to the emulator (which must take values between 0
and 1)}

\item{timepoint}{Simulation timepoint being analysed, if more than one. See
the vignette for analysing more than one timepoint}

\item{timepointscale}{Scale of the timepoints, if being used}
}
\description{
This method runs an ensemble for all parameter value sets specified in a CSV
file generated from spartan latin-hypercube sampling techniques. The output
is a CSV file that can then be analysed using the spartan analysis methods
detailed in Technique 3.
}
